﻿<%@ Page Title="" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="PainOutcomes_Followup.aspx.cs" Inherits="TBI_Instruments_PainOutcomes_Followup" %>


<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>



<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function() {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                    // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Pain Outcomes Questionnaire VA Long Form - Follow Up"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="POQF" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" /><!--&nbsp;-&nbsp;-->
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" Visible="false" Enabled="false" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                
                <br />
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->                    
                    <table style="width:800px; margin-left:20px;">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
<%--                                <!--Date-->
                                <!-- Get text in code-behind -->                                
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="16">
                                </asp:Label> <span class="requiredField">*</span>                                
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="17">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="18" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>--%>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                1
                            </td>
                            <td>
                                <!--Date-->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="dpDateQ1" SkinID="DataLabel" TabIndex="20">
                                </asp:Label> <span class="requiredField">*</span>                                
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDateQ1" runat="server" TabIndex="21">
                                    <Calendar ID="calDateQ1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDateQ1" runat="server" ControlToValidate="dpDateQ1" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                2
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="23">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ2" TabIndex="24"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                3
                            </td>
                            <td>
                                <p>
                                    Approximately how many NON-VA health care visits have you had in the LAST 3
                                    MONTHS for your CURRENT PAIN PROBLEM? Include ALL visits to any NON-VA
                                    health care provider. For example, if you saw a surgeon once, a physical therapist 12
                                    times, and a chiropractor 2 times for reasons related to your pain, the total number of
                                    visits would be 15.
                                </p>
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="txtQ3" SkinID="DataLabel" TabIndex="26"></asp:Label>                                
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtQ3" runat="server" MaxLength="2" Width="25px" TabIndex="27"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="txtQ3" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForQ3" runat="server" TabIndex="29" ControlToValidate="txtQ3" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                4
                            </td>
                            <td>
                                <p>
                                    Approximately how many VA health care visits have you had in the LAST 3
                                    MONTHS for your CURRENT PAIN PROBLEM? Include ALL visits to any VA health
                                    care provider. For example, if you saw a surgeon once, a physical therapist 12 times,
                                    and a chiropractor 2 times for reasons related to your pain, the total number of visits
                                    would be 15.
                                </p>
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="txtQ4" SkinID="DataLabel" TabIndex="31"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtQ4" runat="server" MaxLength="2" Width="25px" TabIndex="32"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="txtQ4" TabIndex="33" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForQ4" runat="server" TabIndex="34" ControlToValidate="txtQ4" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                5
                            </td>
                            <td>
                                <p>
                                    How many times have you experienced a "re-injury of your original pain," that required
                                    medical attention SINCE YOU COMPLETED THIS TREATMENT? 
                                </p>
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="txtQ5" SkinID="DataLabel" TabIndex="35"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtQ5" runat="server" MaxLength="2" Width="25px" TabIndex="36"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="txtQ5" TabIndex="37" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForQ5" runat="server" TabIndex="38" ControlToValidate="txtQ5" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>                            
                        <tr>
                            <td>
                                6
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="41">
                                </asp:Label> (0 = no pain at all / 10 = worst possible pain) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ6" TabIndex="42"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="43" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                7
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="44">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ7" TabIndex="45"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="46" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                8
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="47">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ8" TabIndex="48"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="49" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr> 
                        <tr>
                            <td>
                                9
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="137">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ9" TabIndex="138"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="139" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr> 
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                10
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="141">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ10" TabIndex="142"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="143" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                11
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="144">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11" TabIndex="145"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="146" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                12
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="147">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ12" TabIndex="148"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="149" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                13
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="161">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ13" TabIndex="162"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="163" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                14
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="164">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ14" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ14" TabIndex="165"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQ14" TabIndex="166" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                15
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQ15" SkinID="DataLabel" TabIndex="167">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ15" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ15" TabIndex="168"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="rblQ15" TabIndex="169" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ15" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ15" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ15" runat="server" Visible="false" Value="15" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                16
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="rblQ16" SkinID="DataLabel" TabIndex="170">
                                </asp:Label> (0 = significant limitation in basic activities / 10 = can perform vigorous activities without limitation) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ16" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ16" TabIndex="171"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="rblQ16" TabIndex="172" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ16" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ16" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ16" runat="server" Visible="false" Value="16" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                17
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="rblQ17" SkinID="DataLabel" TabIndex="175">
                                </asp:Label> (0 = totally worn out / 10 = most energy ever) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ17" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ17" TabIndex="176"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQ17" TabIndex="177" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ17" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="17" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                18
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQ18" SkinID="DataLabel" TabIndex="178">
                                </asp:Label> (0 = very poor strength and endurance / 10 = very high strength and endurance) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ18" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ18" TabIndex="179"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQ18" TabIndex="180" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ18" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="18" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                19
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQ19" SkinID="DataLabel" TabIndex="181">
                                </asp:Label> (0 = not depressed at all / 10 = extremely depressed) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ19" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ19" TabIndex="182"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQ19" TabIndex="183" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="19" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                20
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQ20" SkinID="DataLabel" TabIndex="184">
                                </asp:Label> (0 = not anxious at all / 10 = extremely anxious) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ20" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ20" TabIndex="185"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQ20" TabIndex="186" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="20" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                21
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQ21" SkinID="DataLabel" TabIndex="187">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ21" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ21" TabIndex="188"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQ21" TabIndex="189" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ21" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="21" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                22
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="rblQ22" SkinID="DataLabel" TabIndex="190">
                                </asp:Label> (0 = not safe at all / 10 = extremely safe) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ22" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ22" TabIndex="191"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ22" runat="server" ControlToValidate="rblQ22" TabIndex="192" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ22" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ22" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ22" runat="server" Visible="false" Value="22" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                23
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ23" runat="server" AssociatedControlID="rblQ23" SkinID="DataLabel" TabIndex="193">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ23" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ23" TabIndex="194"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ23" runat="server" ControlToValidate="rblQ23" TabIndex="195" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ23" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ23" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ23" runat="server" Visible="false" Value="23" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                24
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ24" runat="server" AssociatedControlID="rblQ24" SkinID="DataLabel" TabIndex="196">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ24" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ24" TabIndex="197"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ24" runat="server" ControlToValidate="rblQ24" TabIndex="198" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ24" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ24" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ24" runat="server" Visible="false" Value="24" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                25
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ25" runat="server" AssociatedControlID="rblQ25" SkinID="DataLabel" TabIndex="211">
                                </asp:Label> (0 = no satisfaction / 10 = complete satisfaction) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ25" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ25" TabIndex="212"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ25" runat="server" ControlToValidate="rblQ25" TabIndex="213" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ25" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ25" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ25" runat="server" Visible="false" Value="25" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                26
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ26" runat="server" AssociatedControlID="rblQ26" SkinID="DataLabel" TabIndex="214">
                                </asp:Label> (0 = not recommended / 10 = strongly recommended) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ26" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ26" TabIndex="215"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ26" runat="server" ControlToValidate="rblQ26" TabIndex="216" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ26" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ26" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ26" runat="server" Visible="false" Value="26" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                27
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ27" runat="server" AssociatedControlID="rblQ27" SkinID="DataLabel" TabIndex="217">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ27" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ27" TabIndex="218"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" OnSelectedIndexChanged="rblQ27_SelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ27" runat="server" ControlToValidate="rblQ27" TabIndex="219" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ27" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ27" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ27" runat="server" Visible="false" Value="27" />
                            </td>
                        </tr>
                        <asp:PlaceHolder ID="plchldrQ28" runat="server" Visible="false">
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    28
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ28" runat="server" AssociatedControlID="txtQ28" SkinID="DataLabel" TabIndex="220"></asp:Label>
                                    <span class="requiredField">*</span><br />
                                    <asp:TextBox ID="txtQ28" runat="server" MaxLength="2" Width="25px" TabIndex="221"></asp:TextBox>&nbsp;percent
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ28" runat="server" ControlToValidate="txtQ28" TabIndex="222" ValidationGroup="OnSave"
                                        Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <asp:RangeValidator ID="RangeValidatorForQ28" runat="server" TabIndex="223" ControlToValidate="txtQ28" ErrorMessage="Must be zero or a positive integer."
                                    MaximumValue="100" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                </td>
                            </tr>
                        </asp:PlaceHolder>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                29
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ29" runat="server" AssociatedControlID="rblQ29" SkinID="DataLabel" TabIndex="229">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ29" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ29" TabIndex="230"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ29" runat="server" ControlToValidate="rblQ29" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ29" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ29" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ29" runat="server" Visible="false" Value="29" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                30
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ30" runat="server" AssociatedControlID="rblQ30" SkinID="DataLabel" TabIndex="241">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ30" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ30" TabIndex="242"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" OnSelectedIndexChanged="rblQ30_SelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ30" runat="server" ControlToValidate="rblQ30" TabIndex="243" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ30" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ30" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ30" runat="server" Visible="false" Value="30" />
                            </td>
                        </tr>
                        <asp:PlaceHolder ID="plchldrQ31_32" runat="server" Visible="false">
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    31
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ31" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="251"></asp:Label>
                                        <br />
                                        <asp:TextBox ID="txtQ31_1" runat="server" MaxLength="2" Width="25px" Font-Bold="true" TabIndex="252"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                        <asp:RangeValidator ID="RangeValidatorForQ31_1" runat="server" TabIndex="253" ControlToValidate="txtQ31_1" ErrorMessage="Must be zero or a positive integer."
                                        MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                        <asp:TextBox ID="txtQ31_2" runat="server" MaxLength="2" Width="25px" TabIndex="254"></asp:TextBox>&nbsp;months
                                        <asp:RangeValidator ID="RangeValidatorForQ31_2" runat="server" TabIndex="255" ControlToValidate="txtQ31_2" ErrorMessage="Must be zero or a positive integer."
                                        MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                        <asp:HiddenField ID="HiddenQ31" runat="server" Visible="false" />
                                </td>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    32
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ32" runat="server" AssociatedControlID="rblQ32" SkinID="DataLabel" TabIndex="261">
                                    </asp:Label> (0 = no relief / 10 = complete relief) <span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblQ32" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ32" TabIndex="262"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                    </asp:RadioButtonList>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ32" runat="server" ControlToValidate="rblQ32" TabIndex="263" ValidationGroup="OnSave"
                                        Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <asp:ObjectDataSource ID="ObjectDataSourceQ32" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ32" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="HiddenQ32" runat="server" Visible="false" Value="32" />
                                </td>
                            </tr>
                        </asp:PlaceHolder>
                        
                        <asp:PlaceHolder ID="plchldrQ33_36" runat="server" Visible="false">
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    33
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ33" runat="server" AssociatedControlID="rblQ33" SkinID="DataLabel" TabIndex="271">
                                    </asp:Label> <span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblQ33" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ33" TabIndex="272"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" OnSelectedIndexChanged="rblQ33_SelectedIndexChanged">
                                    </asp:RadioButtonList>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ33" runat="server" ControlToValidate="rblQ33" TabIndex="273" ValidationGroup="OnSave"
                                        Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <asp:ObjectDataSource ID="ObjectDataSourceQ33" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ33" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="HiddenQ33" runat="server" Visible="false" Value="33" />
                                </td>
                            </tr>
                            <asp:PlaceHolder ID="plchldrQ34_36" runat="server">
                                <tr>
                                    <td colspan="100%">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        34
                                    </td>
                                    <td>
                                        <asp:Label ID="LabelForQ34" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="297"></asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtQ34_1" runat="server" MaxLength="2" Width="25px" Font-Bold="true" TabIndex="298"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                            <asp:RangeValidator ID="RangeValidatorForQ34_1" runat="server" TabIndex="299" ControlToValidate="txtQ34_1" ErrorMessage="Must be zero or a positive integer."
                                            MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                            <asp:TextBox ID="txtQ34_2" runat="server" MaxLength="2" Width="25px" TabIndex="300"></asp:TextBox>&nbsp;months
                                            <asp:RangeValidator ID="RangeValidatorForQ34_2" runat="server" TabIndex="301" ControlToValidate="txtQ34_2" ErrorMessage="Must be zero or a positive integer."
                                            MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                            <asp:HiddenField ID="HiddenQ34" runat="server" Visible="false" />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="100%">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        35
                                    </td>
                                    <td>
                                        <asp:Label ID="LabelForQ35" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="311"></asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtQ35_1" runat="server" MaxLength="2" Width="25px" Font-Bold="true" TabIndex="312"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                            <asp:RangeValidator ID="RangeValidatorForQ35_1" runat="server" TabIndex="313" ControlToValidate="txtQ35_1" ErrorMessage="Must be zero or a positive integer."
                                            MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                            <asp:TextBox ID="txtQ35_2" runat="server" MaxLength="2" Width="25px" TabIndex="314"></asp:TextBox>&nbsp;months
                                            <asp:RangeValidator ID="RangeValidatorForQ35_2" runat="server" TabIndex="315" ControlToValidate="txtQ35_2" ErrorMessage="Must be zero or a positive integer."
                                            MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                            <asp:HiddenField ID="HiddenQ35" runat="server" Visible="false" />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="100%">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        36
                                    </td>
                                    <td>
                                        <asp:Label ID="LabelForQ36" runat="server" AssociatedControlID="rblQ36" SkinID="DataLabel" TabIndex="320">
                                        </asp:Label> (0 = no relief / 10 = complete relief) <span class="requiredField">*</span><br />
                                        <asp:RadioButtonList ID="rblQ36" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ36" TabIndex="321"
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ36" runat="server" ControlToValidate="rblQ36" TabIndex="322" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ36" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                                <asp:ControlParameter ControlID="HiddenQ36" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ36" runat="server" Visible="false" Value="36" />
                                    </td>
                                </tr>
                            </asp:PlaceHolder>
                       </asp:PlaceHolder>
                       
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblSurveyError" runat="server" TabIndex="359" CssClass="requiredField"></asp:Label>
                            </td>
                        </tr>                        

                    </table>
                    
        
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                
                <table style="width:800px; margin-left:20px;">
                    <tr>
                        <td style="width: 20px;">
                            &nbsp;
                        </td>
                        <td>
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </telerik:RadAjaxPanel>
                            <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                                ValidationGroup="OnSaveDraft" TabIndex="360" />
                            <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                                ValidationGroup="OnSave" TabIndex="361" />
                            <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="362" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                        </td>
                    </tr>
                </table>
                
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>




